create or replace package body tbicds.PCK_PAT_ETHNICITY_RACE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  /*
  insert patient ethnicity
  */
  procedure InsertPatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nEthnicityID     in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2) 
  is
    v_vSQL constant varchar2(32767) := 'insert into tbicds.patient_ethnicity
       (patient_id,
        ethnicity_id)
        values
       (:PatientID,
        :EthnicityID)';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID, pi_nEthnicityID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.InsertPatientEthnicity(): ' ||
                           sqlErrm;
  end;

  /*
  insert patient race
  */
  procedure InsertPatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              pi_nRaceID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'insert into tbicds.patient_race
       (patient_id,
        race_id)
        values
       (:PatientID,
        :RaceID)';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID, pi_nRaceID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.InsertPatientRace(): ' ||
                           sqlErrm;
  end;

  /*
  Insert patient ethnicity race source
  */
  procedure InsertPatEthRaceSource(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nSourceID        in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'insert into tbicds.pat_eth_race_source
       (patient_id,
        eth_race_source_id)
        values
       (:PatientID,
        :EthRaceSourceID)';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID, pi_nSourceID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.InsertPatEthRaceSource(): ' ||
                           sqlErrm;
  end;

  /*
  Get ethnicity recordset
  */
  procedure GetEthnicityRS(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           po_nStatusCode      out number,
                           po_vStatusComment   out varchar2,
                           rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select t.*
       from tbicds.stat_ethnicity t
       order by t.sort_order';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetEthnicityRS(): ' ||
                           sqlErrm;
  end;

  /*
  Get race recordset
  */
  procedure GetRaceRS(pi_vSessionID       in varchar2,
                      pi_vSessionClientIP in varchar2,
                      pi_nUserID          in number,
                      po_nStatusCode      out number,
                      po_vStatusComment   out varchar2,
                      rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select t.*
       from tbicds.stat_race t
       order by t.sort_order';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetRaceRS(): ' ||
                           sqlErrm;
  end;

  /*
  Get ethnicity race source recordset
  */
  procedure GetEthRaceSourceRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select t.*
       from tbicds.stat_eth_race_source t';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetEthRaceSourceRS(): ' ||
                           sqlErrm;
  end;

  /*
  Returns patient ethnicity recordset 
  */
  procedure GetPatientEthnicityRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vPatientID       in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select p.*, 
                                      c.item
                                 from tbicds.patient_ethnicity p, 
                                      tbicds.stat_data_collection c
                                where p.patient_id = :PATIENT_ID
                                  and c.collection_type = ''_ETHNICITY''
                                  and p.ethnicity_id = c.collection_item_id(+)';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL
      using pi_vPatientID;
      
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetPatientEthnicityRS(): ' ||
                           sqlErrm;
  end;

  /*
  Returns patient race recordset 
  */
  procedure GetPatientRaceRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_vPatientID       in varchar2,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select race_id from patient_race where patient_id= :PatientID';
    
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL
      using pi_vPatientID;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetPatientRaceRS(): ' ||
                           sqlErrm;
  end;

  /*
  Get patient race lsit as a string
  */
  function GetPatientRaceListString(pi_vPatientID in varchar2) return varchar2
    is
       
    v_vSQL varchar(32767) := 'select t.item as race_title
       from stat_data_collection t
       where t.collection_type = ''_RACE''
         and t.collection_item_id in(select race_id from patient_race where patient_id= :PatientID)
         and t.active = 1
       order by t.collection_item_id';
  
    curPatientRaces pck_common.refCursor;
  
    v_vRace varchar2(32767) := '';
  
    v_vRaceList varchar2(32767) := '';
  begin
    open curPatientRaces for v_vSQL
      using pi_vPatientID;
  
    fetch curPatientRaces
      into v_vRace;
  
    v_vRaceList := v_vRace;
  
    loop
    
      fetch curPatientRaces
        into v_vRace;
      exit when not curPatientRaces%found;
    
      v_vRaceList := v_vRaceList || ', ' || v_vRace;
    
    end loop;
  
    return replace(v_vRaceList, ', ' || v_vRace, ' and ' || v_vRace);
  exception
    when others then
      return null;
  end;

  /*
  Get patient ethnicity race source recordset
  */
  procedure GetPatEthRaceSourceRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                  pi_vPatientID       in varchar2,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2,
                                  rs                  out RetRefCursor)
  is
    v_vSQL varchar2(32767) := 'select p.*, s.eth_race_source_name
       from tbicds.pat_eth_race_source p, tbicds.stat_eth_race_source s
       where p.patient_id = :PatientID
       and p.eth_race_source_id = s.eth_race_source_id';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    open rs for v_vSQL
      using pi_vPatientID;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.GetPatientRaceRS(): ' ||
                           sqlErrm;
  end;

  /*
  Remove patient ethnicity
  */
  procedure DeletePatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2)
   is
    v_vSQL constant varchar2(32767) := 'delete from tbicds.patient_ethnicity p
       where p.patient_id = :PatientID';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.DeletePatientEthnicity(): ' ||
                           sqlErrm;
  end;

  /*
  Remove patient race
  */
  procedure DeletePatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'delete from tbicds.patient_race p
       where p.patient_id = :PatientID';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.DeletePatientRace(): ' ||
                           sqlErrm;
  end;

  /*
  Remove patient ethnicity race source
  */
  procedure DeletePatEthRaceSource(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'delete from tbicds.pat_eth_race_source p
       where p.patient_id = :PatientID';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL
      using pi_vPatientID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.DeletePatEthRaceSource(): ' ||
                           sqlErrm;
  end;

  /*
  Updates patient race selected values 
  */  
  procedure UpdatePatientRace(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              
                              pi_vPatientID in varchar2,
                              pi_vValues    in varchar2,
                              
                              po_nStatusCode    out number,
                              po_vStatusComment out varchar2)
  is
  
    v_vRecDelim   varchar2(1) := ',';
    v_vColDelim   varchar2(1) := ';';
    v_nRecPos     number := 0;
    v_nColPos     number := 0;
    v_nPrevRecPos number := 0;
    v_nPrevColPos number := 0;
    v_vRecord     varchar2(32767) := '';
    v_vColumn     varchar2(32767) := '';
    v_nColIndex   number := 0;
  
    --
    v_vValue varchar2(4000);
  
  begin
  
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    if ((pi_vValues is null) or (LENGTH(pi_vValues) < 1)) then
      return;
    else
      delete from patient_race t where t.patient_id = pi_vPatientID;
    end if;
  
    --split records
    loop
      v_nRecPos := INSTR(pi_vValues, v_vRecDelim, v_nRecPos + 1);
      exit when v_nRecPos = 0;
      v_vRecord     := substr(pi_vValues,
                              v_nPrevRecPos + 1,
                              v_nRecPos - v_nPrevRecPos - 1);
      v_nPrevRecPos := v_nRecPos;
    
      --split columns from record
      --v_nColPos     := 0;
      --v_nPrevColPos := 0;
      --v_vColumn     := '';
      --v_nColIndex   := 0;
    
      --loop
      --  v_nColPos := INSTR(v_vRecord, v_vColDelim, v_nColPos + 1);
      --  exit when v_nColPos = 0;
      --  v_vColumn     := substr(v_vRecord,
      --                          v_nPrevColPos + 1,
      --                          v_nColPos - v_nPrevColPos - 1);
      --  v_nPrevColPos := v_nColPos;
    
      --  --loop columns
      --  if v_nColIndex = 0 then
      --    v_vValue := v_vColumn;
      --  end if;
    
      --  v_nColIndex := v_nColIndex + 1;
      --end loop;
    
      --do something here
      insert into patient_race
        (patient_id, race_id)
      values
        (pi_vPatientID, to_number(v_vRecord));
    
    end loop;
  
    commit;
  
  exception
    when others then
    
      po_nStatusCode    := 1;
      po_vStatusComment := '';
    
  end;

  /*
  Updates patient ethnicity 
  */ 
  procedure UpdatePatientEthnicity(pi_vSessionID       in varchar2,
                                   pi_vSessionClientIP in varchar2,
                                   pi_nUserID          in number,
                                   pi_vPatientID       in varchar2,
                                   pi_nEthnicityID     in number,
                                   po_nStatusCode      out number,
                                   po_vStatusComment   out varchar2)
  is
    v_vSQL constant varchar2(32767) := 'insert into tbicds.patient_ethnicity
       (patient_id,
        ethnicity_id)
        values
       (:PatientID,
        :EthnicityID)';
  
    v_vSQL2 constant varchar2(32767) := 'delete from tbicds.patient_ethnicity t
        where t.patient_id = :PatientID';
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    execute immediate v_vSQL2
      using pi_vPatientID;
  
    execute immediate v_vSQL
      using pi_vPatientID, pi_nEthnicityID;
    commit;
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := 'PCK_PAT_ETHNICITY_RACE.UpdatePatientEthnicity(): ' ||
                           sqlErrm;
  end;

end;
/

